/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.ReadOnly;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;

public class ProtocolFilterPortWidget
extends Panel
implements JDMInput {
    static byte[] bitMaskArray = new byte[]{-128, 1, 2, 4, 8, 16, 32, 64};
    private static OctetString forwardMapping = new OctetString("FFFFFFFFFF");
    private static OctetString filterMapping = new OctetString("0000000000");
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private static ResourceBundle lspeedBundle = null;
    private static int MAX_PORTS = 40;
    private OctetString portMapping;
    private int numOfPorts;
    private boolean unknownPolicyRow = false;
    private Vector widgetList;
    private GridLayout layout;
    private String allPortsCheckboxName;
    private String port1CheckboxName;

    private static ResourceBundle getLspeedBundle() {
        if (lspeedBundle == null) {
            lspeedBundle = ResourceBundle.getBundle(bundleName);
        }
        return lspeedBundle;
    }

    public ProtocolFilterPortWidget() {
        Object[] objectArray = new Object[1];
        this.widgetList = new Vector();
        this.layout = new GridLayout();
        this.layout.setRows(MAX_PORTS / 4);
        this.layout.setColumns(4);
        this.setLayout(this.layout);
        this.allPortsCheckboxName = ProtocolFilterPortWidget.getLspeedBundle().getString("ProtoFilterAllPortsCheckboxItem");
        objectArray[0] = new Integer(1);
        this.port1CheckboxName = MessageFormat.format(ProtocolFilterPortWidget.getLspeedBundle().getString("ProtoFilterPortCheckboxItem"), objectArray);
        int n = 1;
        while (n <= MAX_PORTS) {
            objectArray[0] = new Integer(n);
            String string = MessageFormat.format(ProtocolFilterPortWidget.getLspeedBundle().getString("ProtoFilterPortCheckboxItem"), objectArray);
            Checkbox checkbox = new Checkbox(string);
            checkbox.setVisible(false);
            this.add(checkbox);
            this.widgetList.addElement(checkbox);
            ++n;
        }
    }

    public Object getValue() {
        OctetString octetString;
        if (this.unknownPolicyRow) {
            Checkbox checkbox = (Checkbox)this.widgetList.elementAt(0);
            octetString = checkbox.getState() ? new OctetString(forwardMapping) : new OctetString(filterMapping);
        } else {
            octetString = new OctetString("0000000000");
            int n = 1;
            while (n <= this.widgetList.size()) {
                Checkbox checkbox = (Checkbox)this.widgetList.elementAt(n - 1);
                if (checkbox.getState()) {
                    this.setPortInEncodedString(n, octetString);
                }
                ++n;
            }
        }
        Vector<Serializable> vector = new Vector<Serializable>();
        vector.addElement(octetString);
        vector.addElement(new ReadOnly());
        vector.addElement(new ReadOnly());
        return vector;
    }

    public boolean isValidValue() {
        return true;
    }

    public boolean ignoreValue() {
        return false;
    }

    public void setValue(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            if (vector.elementAt(0) instanceof OctetString) {
                System.out.println("Vector element 0 is octet string");
                this.portMapping = (OctetString)vector.elementAt(0);
            }
            if (vector.elementAt(1) instanceof Integer) {
                System.out.println("Vector element 1 is integer");
                this.numOfPorts = (Integer)vector.elementAt(1);
            }
            this.setUnknownPolicyRow(false);
            if (vector.elementAt(2) instanceof Integer && (Integer)vector.elementAt(2) == 4) {
                this.setUnknownPolicyRow(true);
            }
        } else {
            System.out.println("Protocol Filter Port Widget ... Unrecognized input");
            return;
        }
        if (this.unknownPolicyRow) {
            Checkbox checkbox = (Checkbox)this.widgetList.elementAt(0);
            checkbox.setLabel(this.allPortsCheckboxName);
            checkbox.setState(this.testPolicyInEncodedString(this.portMapping));
            checkbox.setVisible(true);
            int n = 2;
            while (n <= MAX_PORTS) {
                checkbox = (Checkbox)this.widgetList.elementAt(n - 1);
                checkbox.setVisible(false);
                ++n;
            }
        } else {
            Checkbox checkbox = (Checkbox)this.widgetList.elementAt(0);
            checkbox.setLabel(this.port1CheckboxName);
            if (this.numOfPorts == 0) {
                this.numOfPorts = this.portMapping.value.length * 8;
            }
            int n = 1;
            while (n <= this.widgetList.size()) {
                checkbox = (Checkbox)this.widgetList.elementAt(n - 1);
                checkbox.setState(this.testPortInEncodedString(n, this.portMapping));
                if (n <= this.numOfPorts) {
                    checkbox.setVisible(true);
                } else {
                    checkbox.setVisible(false);
                }
                ++n;
            }
        }
        this.doLayout();
    }

    public void setValue(String string) {
        try {
            OctetString octetString = new OctetString(string);
            this.setValue(octetString);
            return;
        }
        catch (Exception exception) {
            Label label = new Label();
            label.setText(string.toString());
            this.add(label);
            return;
        }
    }

    public void setNumOfPorts(int n) {
        this.numOfPorts = n;
    }

    public void setUnknownPolicyRow(boolean bl) {
        this.unknownPolicyRow = bl;
    }

    private boolean testPortInEncodedString(int n, OctetString octetString) {
        int n2 = n % 8;
        byte by = bitMaskArray[n2];
        int n3 = n2 != 0 ? n / 8 : n / 8 - 1;
        if (n3 >= octetString.value.length) {
            return true;
        }
        int n4 = octetString.value.length - n3 - 1;
        boolean bl = (octetString.value[n4] & by) == by;
        return bl;
    }

    private void setPortInEncodedString(int n, OctetString octetString) {
        int n2 = n % 8;
        byte by = bitMaskArray[n2];
        int n3 = n2 != 0 ? n / 8 : n / 8 - 1;
        if (n3 >= octetString.value.length) {
            return;
        }
        int n4 = octetString.value.length - n3 - 1;
        octetString.value[n4] = (byte)(octetString.value[n4] | by);
    }

    private boolean testPolicyInEncodedString(OctetString octetString) {
        boolean bl = true;
        if (octetString == filterMapping) {
            bl = false;
        }
        return bl;
    }
}

